package voicent.ivrsample;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class IvrSampleGetFiles
{
  // must have default constructor
  public IvrSampleGetFiles() {}

  public Properties get(String dir, String ext)
  {
    Properties props = new Properties();

    int total = 0;
    String prompt = "Please ";
    String list = "";

    File listDir = new File(dir);
    if (listDir.exists()) {
      File files[] = listDir.listFiles();
      if (files != null) {
        for (int i = 0; i < files.length; i++) {
          String fname = files[i].getName();
          if (! fname.endsWith(ext))
            continue;

          total++;
          String nameonly = fname.substring(0, fname.length() - ext.length());

          prompt += "press "+Integer.toString(total)+" for "+nameonly + "; ";
          list += "\"" + dir + "\\" + fname + "\" ";
        }
      }
    }

    props.setProperty("total", Integer.toString(total));
    props.setProperty("promptmsg", prompt);
    props.setProperty("list", list);

    return props;   
  }

  // for test independent of IVR Studio
  public static void main(String[] args)
    throws IOException
  {
    IvrSampleGetFiles obj = new IvrSampleGetFiles();
    Properties props = obj.get("C:\\Call List", ".voc");
    props.store(System.out, "test");
  }
}
